﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;

/// <summary>
/// Summary description for CLabData
/// </summary>
public class CSiteDataXfer : CData
{
    /// <summary>
    /// US:5348 construstor
    /// </summary>
    /// <param name="data"></param>
    public CSiteDataXfer(CData data)
        : base(data)
    {
        //constructors are not inherited in c#!
    }


    /// <summary>
    /// US:5348 save a region to the central db
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="lRegionID"></param>
    /// <param name="strRegionName"></param>
    /// <returns></returns>
    public CStatus SaveRegion( long lXferSystemID,
                               long lRegionID,
                               string strRegionName)
    {
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                  base.ClientIP,
                                                  base.UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nRegionID", lRegionID);
        pList.AddInputParameter("pi_vRegionName", strRegionName);

        return DBConn.ExecuteOracleSP("PCK_XFER.XferRegion",
                                       pList);
    }


    /// <summary>
    /// US:5348 Save a site to the central db
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="strSiteName"></param>
    /// <returns></returns>
    public CStatus SaveSite( long lXferSystemID,
                             long lRegionID,
                             long lSiteID,
                             string strSiteName)
    {
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                  base.ClientIP,
                                                  base.UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nRegionID", lRegionID);
        pList.AddInputParameter("pi_nSiteID", lSiteID);
        pList.AddInputParameter("pi_vSiteName", strSiteName);

        return DBConn.ExecuteOracleSP("PCK_XFER.XferSite",
                                       pList);
    }
        
}